/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2005 by Myricom, Inc.  All rights reserved.                 *
 *************************************************************************/

/* Simple pingpong to make parity error recovery easier to test. Slave
   takes one parameter, length of pingpong. Master takes two: length and
   name of slave. */

#include <stdio.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_byteswap.h"

#define MY_EID 1
#define MY_EKEY 0x1234

void foo(int len, char *target)
{
  mx_return_t ret;
  mx_endpoint_t ep;
  uint32_t sseq = 0;
  uint32_t rseq = 0;
  mx_segment_t rseg;
  mx_segment_t sseg;
  char *rbuf;
  char *sbuf;
  mx_request_t rreq;
  mx_request_t sreq;
  mx_endpoint_addr_t dest_addr;
  uint64_t dest_nic_id;
  mx_status_t status;
  uint32_t result;
  uint64_t nic_id;
  uint32_t eid;
  mx_endpoint_addr_t my_addr;
  uint32_t junk;

  sbuf = malloc(len);
  if (sbuf == NULL) {
    printf("sbuf == NULL\n");
    exit(0);
  }
  rbuf = malloc(len);
  if (rbuf == NULL) {
    printf("rbuf == NULL\n");
    exit(0);
  }

  mx_init();
  ret = mx_open_endpoint(MX_ANY_NIC, MY_EID, MY_EKEY, NULL, 0, &ep);
  if (ret != MX_SUCCESS) {
    printf("mx_open_endpoint failed %d\n", (int)ret);
  }

  if (target == NULL) {
    printf("slave\n");
    rseg.segment_ptr = &eid;
    rseg.segment_length = sizeof (eid);
    ret = mx_irecv(ep, &rseg, 1, rseq, MX_MATCH_MASK_NONE, 0, &rreq);
    rseq++;
    ret = mx_wait(ep, &rreq, MX_INFINITE, &status, &result);

    /* Master sent eid. Use it to connect. */
    mx_decompose_endpoint_addr(status.source, &nic_id, &junk);
    ret = mx_connect(ep, nic_id, ntohl(eid), MY_EKEY, MX_INFINITE,
		     &dest_addr);

    /* Prepost a receive. */
    rseg.segment_ptr = rbuf;
    rseg.segment_length = len;
    ret = mx_irecv(ep, &rseg, 1, rseq, MX_MATCH_MASK_NONE, 0, &rreq);
    rseq++;

    sseg.segment_ptr = NULL;
    sseg.segment_length = 0;
    ret = mx_isend(ep, &sseg, 1, dest_addr, sseq, 0, &sreq);
    sseq++;
    ret = mx_wait(ep, &sreq, MX_INFINITE, &status, &result);
  }
  else {
    printf("master\n");
    ret = mx_hostname_to_nic_id(target, &dest_nic_id);
    ret = mx_connect(ep, dest_nic_id, MY_EID, MY_EKEY, MX_INFINITE,
		     &dest_addr);

    /* Send eid to slave so that it can do a connect. */
    mx_get_endpoint_addr(ep, &my_addr);
    mx_decompose_endpoint_addr(my_addr, &nic_id, &eid);
    eid = htonl(eid);
    sseg.segment_ptr = &eid;
    sseg.segment_length = sizeof (eid);
    ret = mx_isend(ep, &sseg, 1, dest_addr, sseq, 0, &sreq);
    sseq++;
    do {
      ret = mx_test(ep, &sreq, &status, &result);
    } while (ret == MX_SUCCESS && !result);

    rseg.segment_ptr = rbuf;
    rseg.segment_length = len;
    ret = mx_irecv(ep, &rseg, 1, rseq, MX_MATCH_MASK_NONE, 0, &rreq);
    rseq++;
    ret = mx_wait(ep, &rreq, MX_INFINITE, &status, &result);
  }

  sseg.segment_ptr = sbuf;
  sseg.segment_length = len;
  rseg.segment_ptr = rbuf;
  rseg.segment_length = len;

  for (;;) {
    ret = mx_isend(ep, &sseg, 1, dest_addr, sseq, 0, &sreq);
    sseq++;
    printf("send %x posted\n", sseq-1);
    ret = mx_irecv(ep, &rseg, 1, rseq, MX_MATCH_MASK_NONE, 0, &rreq);
    rseq++;
    printf("recv %x posted\n", rseq-1);
    do {
      ret = mx_test(ep, &sreq, &status, &result);
    } while (ret == MX_SUCCESS && !result);
    printf("send %x complete\n", sseq-1);
    do {
      ret = mx_test(ep, &rreq, &status, &result);
    } while (ret == MX_SUCCESS && !result);
    printf("recv %x complete\n", rseq-1);
  }

  mx_finalize();
}

int main(int argc, char **argv)
{
  switch (argc) {
  case 2:
    foo(atoi(argv[1]), NULL);
    break;
  case 3:
    foo(atoi(argv[1]), argv[2]);
    break;
  default:
    printf("usage: %s <iter> [slave]\n", argv[0]);
    break;
  }
  return 0;
}
